function Character(name, hp, mp, lv)
{
	this.name = name;
	this.hp = hp;
	this.maxhp = hp;
	this.mp = mp;
	this.maxmp = mp;
	this.lv = lv;
	this.exp = 0;
	this.next = 20;
	FigureLV(this, lv - 1);
	this.obtained = true;
	this.face = LoadImage("Face-" + name + ".png");
	this.power = 5;
	this.speed = 5;
	this.precise = 5;
	this.magic = 5;
	this.resist = 5;
	this.mresist = 5;
	this.sta = 0; // Character's stamina
	this.starec = 10; // Character's Stamina Recovery
	this.spells = new Array();
	this.turn = false;
	this.krylic = new Array();
	this.summoned = false;
	this.techniques = new Array();
	this.items = new Array();
	this.ailments = AilmentArray();
	this.commands = CommandArray();
	// Following is the stuff for the character's profile in the Character submenu
	this.description = "";
	this.age = 10;
	this.sex = "M";
	this.origin = "";
	this.height = 10;
	this.weight = 10;
	this.build = "";
	this.weapon = "";
	this.hand = "";
}

Character.prototype.endTurn = function()
{
	this.sta = 0;
	this.turn = false;
	Game.currentbattle.situation = "Time";
	// Check for ailments and such
}

function AilmentArray()
{
	var ailments = new Array();
	ailments["Poison"] = false;
	ailments["Mute"] = false;
	return ailments;
}

function CommandArray()
{
	var commands = new Array(5);
	commands[0] = "Attack";
	commands[1] = "Techniques";
	commands[2] = "Spells";
	commands[3] = "Defend";
	commands[4] = "Item";
	return commands;
}

function FigureLV(character, amount)
{
	for (var i = 0; i < amount; i ++)
	{
		character.exp += character.next;
		character.next += (i + 2) * 10;
	}
}

Damizean = new Character("Damizean", 624, 100, 14);
Damizean.power = 9;
Damizean.speed = 8;
Damizean.precise = 85;
Damizean.resist = 5;
Damizean.magic = 7;
Damizean.mresist = 7;
Damizean.starec = 11;
Damizean.description = "Silent Protagonist";
Damizean.age = 17;
Damizean.origin = "Aeror";
Damizean.height = 70;
Damizean.weight = 152;
Damizean.build = "Medium";
Damizean.weapon = "Long Sword";
Damizean.hand = "Right-handed";
Damizean.items[0] = Items.Weapons.WoodBlade;
Damizean.items[1] = Items.Armor.ClothTunic;
Damizean.items[2] = Items.Armor.Armlet;
Damizean.items[3] = Items.Armor.HideCap;
Damizean.items[4] = EmptyItem;

Annika = new Character("Annika", 424, 100, 24);
Annika.speed = 10;
Annika.precise = 12;
Annika.resist = 6;
Annika.mresist = 8;
Annika.description = "Budding Engineer";
Annika.age = 16;
Annika.sex = "F";
Annika.origin = "Aeror";
Annika.height = 64;
Annika.weight = 105;
Annika.build = "Small";
Annika.weapon = "Hammer";
Annika.hand = "Right-handed";
Annika.items[0] = Items.Weapons.WoodBlade;
Annika.items[1] = Items.Armor.ClothTunic;
Annika.items[2] = Items.Armor.Armlet;
Annika.items[3] = Items.Armor.HideCap;
Annika.items[4] = EmptyItem;

Dan = new Character("Richt", 10, 10, 15);
Dan.obtained = false;

Richt = new Character("Richt", 124, 100, 5);
Richt.speed = 10;
Richt.precise = 12;
Richt.resist = 6;
Richt.mresist = 8;
Richt.starec = 12;
Richt.description = "Goal-driven Werewolf";
Richt.age = "Unknown";
Richt.origin = "Unknown";
Richt.height = 75;
Richt.weight = 235;
Richt.build = "Beastly";
Richt.weapon = "Claws";
Richt.hand = "Right-handed";
Richt.items[0] = Items.Weapons.WoodBlade;
Richt.items[1] = Items.Armor.ClothTunic;
Richt.items[2] = Items.Armor.Armlet;
Richt.items[3] = Items.Armor.HideCap;
Richt.items[4] = EmptyItem;